/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class CustomFileSystemView
extends FileSystemView {
    private static final String newFolderString = UIManager.getString("FileChooser.other.newFolder");
    private static final String newFolderNextString = UIManager.getString("FileChooser.other.newFolder.subsequent");
    private File[] files;

    public CustomFileSystemView(File[] f) {
        this.files = f;
    }

    public CustomFileSystemView(List<String> pathList) {
        ArrayList<File> list = new ArrayList<File>();
        for (String path : pathList) {
            File f = new File(path);
            if (f == null) continue;
            list.add(f);
        }
        this.files = list.toArray(new File[0]);
    }

    @Override
    public Boolean isTraversable(File f) {
        String s1 = f.getAbsolutePath().toLowerCase();
        String s2 = null;
        for (File f1 : this.files) {
            s2 = f1.getAbsolutePath().toLowerCase();
            if (!s1.startsWith(s2) || !f.isDirectory()) continue;
            return true;
        }
        return false;
    }

    @Override
    public File[] getRoots() {
        File[] roots = this.files;
        for (int i = 0; i < roots.length; ++i) {
            if (!this.isFileSystemRoot(roots[i])) continue;
            roots[i] = this.createFileSystemRoot(roots[i]);
        }
        return roots;
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        if (dir != null && dir.isDirectory()) {
            for (int i = 0; i < this.files.length; ++i) {
                if (!dir.equals(this.files[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public File getDefaultDirectory() {
        return this.files[0];
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, newFolderString);
        for (int i = 2; newFolder.exists() && i < 100; --i) {
            newFolder = this.createFileObject(containingDir, MessageFormat.format(newFolderNextString, new Integer(i)));
        }
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        newFolder.mkdirs();
        return newFolder;
    }
}

